IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO](
	[CD_EMP] [int] NOT NULL,
	[CD_ALT_PRECO] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_ALT_PRECO] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO_CD_ALT_PRECO]  DEFAULT ((0)) FOR [CD_ALT_PRECO]

ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO_EST_PROD_PRECO_ALT_CPL] FOREIGN KEY([CD_EMP], [CD_ALT_PRECO], [CD_PROD])
REFERENCES [dbo].[EST_PROD_PRECO_ALT_CPL] ([CD_EMP], [CD_ALT_PRECO], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO] CHECK CONSTRAINT [FK_EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO_EST_PROD_PRECO_ALT_CPL]
END